/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EventHooks;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.constants.RoleType;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.entity.data.role.IRoleTransporter;
import noppes.npcs.api.event.RoleEvent;
import noppes.npcs.api.handler.data.IQuestObjective;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerTransportData;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.controllers.data.TransportLocation;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleInterface;
import noppes.npcs.util.Util;

public class RoleTransporter
extends RoleInterface
implements IRoleTransporter {
    public String name = "";
    private int ticks = 10;
    public int transportId = -1;

    public RoleTransporter(EntityNPCInterface npc) {
        super(npc);
        this.type = RoleType.TRANSPORTER;
    }

    @Override
    public boolean aiShouldExecute() {
        --this.ticks;
        if (this.ticks > 0) {
            return false;
        }
        this.ticks = 10;
        if (!this.hasTransport()) {
            return false;
        }
        TransportLocation loc = this.getLocation();
        if (loc.type != 0) {
            return false;
        }
        List inRange = new ArrayList();
        try {
            inRange = this.npc.field_70170_p.func_72872_a(EntityPlayer.class, this.npc.func_174813_aQ().func_72314_b(6.0, 6.0, 6.0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (EntityPlayer player : inRange) {
            if (!this.npc.canSee((Entity)player)) continue;
            this.unlock(player, loc);
        }
        return false;
    }

    @Override
    public TransportLocation getLocation() {
        if (!this.npc.func_70613_aW()) {
            return null;
        }
        return TransportController.getInstance().getTransport(this.transportId);
    }

    public boolean hasTransport() {
        TransportLocation loc = this.getLocation();
        return loc != null && loc.id == this.transportId;
    }

    @Override
    public void interact(EntityPlayer player) {
        if (this.hasTransport()) {
            TransportLocation loc = this.getLocation();
            if (loc.type == 2) {
                this.unlock(player, loc);
            }
            NoppesUtilServer.sendOpenGui(player, EnumGuiType.PlayerTransporter, this.npc);
        }
    }

    private boolean isItemEqual(ItemStack stack, ItemStack other) {
        return !other.func_190926_b() && stack.func_77973_b() == other.func_77973_b() && (stack.func_77952_i() < 0 || stack.func_77952_i() == other.func_77952_i());
    }

    @Override
    public void load(NBTTagCompound compound) {
        super.load(compound);
        this.type = RoleType.TRANSPORTER;
        this.transportId = compound.func_74762_e("TransporterId");
        TransportLocation loc = this.getLocation();
        this.name = "";
        if (loc != null) {
            this.name = loc.name;
        }
    }

    public void setTransport(TransportLocation location) {
        this.transportId = location.id;
        this.name = location.name;
        location.npc = this.npc.func_110124_au();
    }

    public void transport(EntityPlayerMP player, int id) {
        TransportLocation loc = TransportController.getInstance().getTransport(id);
        PlayerData playerdata = CustomNpcs.proxy.getPlayerData((EntityPlayer)player);
        if (loc == null || !loc.isDefault() && !playerdata.transportData.transports.contains(loc.id)) {
            return;
        }
        RoleEvent.TransporterUseEvent event = new RoleEvent.TransporterUseEvent((EntityPlayer)player, this.npc.wrappedNPC, loc.copy());
        if (EventHooks.onNPCRole(this.npc, event) || event.location == null) {
            return;
        }
        TransportLocation locEvent = (TransportLocation)event.location;
        if (!player.field_71075_bZ.field_75098_d) {
            if (locEvent.money > 0L) {
                if (locEvent.money > playerdata.game.getMoney()) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("transporter.hover.not.money", new Object[0]));
                    return;
                }
                playerdata.game.addMoney(-1L * locEvent.money);
            }
            if (!locEvent.inventory.func_191420_l()) {
                Map<ItemStack, Boolean> barterItems = Util.instance.getInventoryItemCount((EntityPlayer)player, locEvent.inventory);
                for (ItemStack stack : barterItems.keySet()) {
                    if (barterItems.get(stack).booleanValue()) continue;
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("transporter.hover.not.money", new Object[0]));
                    return;
                }
                block1: for (ItemStack stack : barterItems.keySet()) {
                    int amount = stack.func_190916_E();
                    for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                        ItemStack is = player.field_71071_by.func_70301_a(i);
                        if (!this.isItemEqual(stack, is)) continue;
                        if (amount < is.func_190916_E()) {
                            is.func_77979_a(amount);
                            continue block1;
                        }
                        player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                        amount -= is.func_190916_E();
                    }
                }
                player.field_71069_bz.func_75142_b();
                for (QuestData data : playerdata.questData.activeQuests.values()) {
                    for (IQuestObjective obj : data.quest.getObjectives((IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)player))) {
                        if (obj.getType() != 0) continue;
                        playerdata.questData.checkQuestCompletion((EntityPlayer)player, data);
                    }
                }
            }
        }
        NoppesUtilPlayer.teleportPlayer(player, locEvent.pos.func_177958_n(), locEvent.pos.func_177956_o(), locEvent.pos.func_177952_p(), locEvent.dimension, locEvent.yaw, locEvent.pitch);
    }

    private void unlock(EntityPlayer player, TransportLocation loc) {
        PlayerTransportData data = CustomNpcs.proxy.getPlayerData((EntityPlayer)player).transportData;
        if (data.transports.contains(this.transportId)) {
            return;
        }
        RoleEvent.TransporterUnlockedEvent event = new RoleEvent.TransporterUnlockedEvent(player, this.npc.wrappedNPC);
        if (EventHooks.onNPCRole(this.npc, event)) {
            return;
        }
        data.transports.add(this.transportId);
        player.func_145747_a((ITextComponent)new TextComponentTranslation("transporter.unlock", new Object[]{new TextComponentTranslation(loc.name, new Object[0]).func_150254_d(), new TextComponentTranslation(loc.category.title, new Object[0]).func_150254_d()}));
    }

    @Override
    public NBTTagCompound save(NBTTagCompound compound) {
        super.save(compound);
        compound.func_74768_a("TransporterId", this.transportId);
        return compound;
    }
}

